/*
    L3G4200D Triple Axis Gyroscope: Pitch, Roll and Yaw.
    Read more: http://www.jarzebski.pl/arduino/czujniki-i-sensory/3-osiowy-zyroskop-l3g4200d.html
    GIT: https://github.com/jarzebski/Arduino-L3G4200D
    Web: http://www.jarzebski.pl
    (c) 2014 by Korneliusz Jarzebski
*/

#include <Wire.h>
//#include <delay.h>
#include "L3G4200D.h"
#include "ADXL345.h"
#include "Adafruit_BMP085.h" 
#include "HMC5883L.h"
#include "DHT.h" //Biblioteka służąca do obsługi czujnika DHT11

//************
#include <SD.h>
//************

//*************
#define CS 4
//*************

//*********************************
File temp_file;
File cisn_file;

String temp_string;
String cisn_string;

int temp_sensor;
int cisn_sensor;
//*********************************


L3G4200D gyroscope;
ADXL345 accelerometer;
HMC5883L compass;
Adafruit_BMP085 bmp;

#define DHTPIN 18 //Linia danych czujnika podłączona do cyfrowego pinu 18
#define DHTTYPE DHT22 //Definicja typu czujnika
float wilgotnosc; //Zmienna przechowująca wilgotność
float temperatura; //Zmienna przechowująca temperaturę

DHT dht(DHTPIN, DHTTYPE); //Definicja czujnika, typ i numer pinu

//IO ports configuration
const int gy80_GND = 14;      // 'Minus' zasilania gy80
const int gy80_PWR = 15;      // 'Plus' zasilania gy80
const int dht_GND = 17;      // 'Minus' zasilania gy80
const int dht_PWR = 19;      // 'Plus' zasilania gy80


// Timers
unsigned long timer = 0;
float timeStep = 1;

// Pitch, Roll and Yaw values
float pitch = 0;
float roll = 0;
float yaw = 0;

void setup() 
{

  //Konfiguracja Portów zasilających
 pinMode(gy80_GND, OUTPUT);
 pinMode(gy80_PWR, OUTPUT);
 pinMode(dht_GND, OUTPUT);
 pinMode(dht_PWR, OUTPUT);
 pinMode(DHTPIN, INPUT_PULLUP);
 
 digitalWrite(gy80_PWR, HIGH);
 digitalWrite(gy80_GND, LOW);
 digitalWrite(dht_PWR, HIGH);
 digitalWrite(dht_GND, LOW);


 //Inicjalizacja portu szeregowego (do komunikacji z komputerem
 Serial.begin(9600);
 
  // Initialize L3G4200D
  Serial.println("Initialize L3G4200D");
  // Set scale 2000 dps and 400HZ Output data rate (cut-off 50)
  while(!gyroscope.begin(L3G4200D_SCALE_2000DPS, L3G4200D_DATARATE_400HZ_50))
  {
    Serial.println("Could not find a valid L3G4200D sensor, check wiring!");
    delay(500);
  }
  // Calibrate gyroscope. The calibration must be at rest.
  // If you don't want calibrate, comment this line.
  gyroscope.calibrate(100);


  // Initialize accelerometer
  Serial.println("Inicjalizacja ADXL345");
  if (!accelerometer.begin())
  {
    Serial.println("Nie odnaleziono ADXL345, sprawdz podlaczenie!");
    delay(500);
  }
  accelerometer.setRange(ADXL345_RANGE_16G);
  
   // Inicjalizacja HMC5883L
   Serial.println("Initialize HMC5883L");
   while (!compass.begin())
   {
     Serial.println("Nie odnaleziono HMC5883L, sprawdz polaczenie!");
     delay(500);
   }

  // Inicjalizacja barometru/termometru; domyslnie 3 - super wysoka precyzja - najwolniejszy pomiar
  if (!bmp.begin())
  {
    Serial.println("Nie odnaleziono czujnika BMP085 / BMP180");
    while (1) {}
  }


 
  dht.begin();            //Inicjalizacja pracy czujnika dht

  //**************************************************************************************
  Serial.print("Inicjalizacja karty SD..."); //drukujemy status na port szeregowy
  if (!SD.begin(CS)) { //inicjalizacja karty pamięci i sprawdzenie stanu  inicjalizacji
    Serial.println("niepowodzenie!");
    return;
  }
  Serial.println("OK.");
  //**************************************************************************************
}


void loop()
{
  timer = millis();
//******************************************************************************************************************************
  temp_string = "";
  float temp = bmp.readPressure();
  temp_string = String(millis()/1000) + "," + String(bmp.readTemperature(),3) + "," + String(temp,3) + "," + String(bmp.readAltitude(102520),3); //stworzenie stringa tekstowego ze znacznikiem czasu i danymi

  temp_file = SD.open("temp.txt",FILE_WRITE);

  if (temp_file)
  {
    temp_file.println(temp_string);
    temp_file.close();

    Serial.println("");
    Serial.print("Podglad zapisu na karcie SD: ");
    Serial.println(temp_string);
    Serial.println("");
  }
  else
  {
    Serial.println("Błąd przy otwieraniu pliku...");
  }
//******************************************************************************************************************************



  // Read normalized values from giroscope
  Vector normg = gyroscope.readNormalize();
  // Variable normg contains actual gyroscope data! You can calculate Pitch, Roll and Yaw:
  pitch = pitch + normg.YAxis * timeStep;
  roll = roll + normg.XAxis * timeStep;
  yaw = yaw + normg.ZAxis * timeStep;
  // Output data through serial port
  Serial.println();
  Serial.print(" Pitch = ");
  Serial.print(normg.YAxis);
  Serial.print(" Roll = ");
  Serial.print(normg.XAxis);  
  Serial.print(" Yaw = ");
  Serial.println(normg.ZAxis);

  // Read normalized values from accelerometer
  Vector norma = accelerometer.readNormalize();
  // Variable norma contains actual accelerometer data!
  // Wyswietlenie danych znormalizowanych m/s^2
  Serial.print(" Acc_X = ");
  Serial.print(norma.XAxis);
  Serial.print(" Acc_Y = ");
  Serial.print(norma.YAxis);
  Serial.print(" Acc_Z = ");
  Serial.print(norma.ZAxis);
  Serial.println();

  // Read normalized values from magnetometer
  Vector normmag = compass.readNormalize();
  // Variable normmag contains actual magnetometer data!
  // Wyswielnie wynikow
  Serial.print(" MAG_X = ");
  Serial.print(normmag.XAxis);
  Serial.print(" MAG_Y = ");
  Serial.print(normmag.YAxis);
  Serial.print(" MAG_Z = ");
  Serial.print(normmag.ZAxis);
  Serial.println();  


  //Pressure and temperature from gy80 sensor
     // Odczytujemy temperaturę
    Serial.print("Temperatura = ");
    Serial.print(bmp.readTemperature());
    Serial.println(" *C");
    // Odczytujemy cisnienie
    Serial.print("Cisnienie = ");
    Serial.print(bmp.readPressure());
    Serial.println(" Pa");
    // Obliczamy wysokosc dla domyslnego cisnienia przy pozimie morza
    // p0 = 1013.25 millibar = 101325 Pascal
    Serial.print("Wysokosc = ");
    Serial.print(bmp.readAltitude());
    Serial.println(" metrow");
    // Jesli znamy aktualne cisnienie przy poziomie morza,
    // mozemy dokladniej wyliczyc wysokosc, padajac je jako parametr
    Serial.print("Rzeczywista wysokosc = ");
    Serial.print(bmp.readAltitude(102520));
    Serial.println(" metrow");    
    Serial.println();

    //Humidity and temperature from DTH sensor
    temperatura = dht.readTemperature();
    wilgotnosc = dht.readHumidity();

    //Wyświetlenie temperatury i wilgotności w serial port
    Serial.print("Temperatura: ");
    Serial.print(temperatura);
    Serial.println("*C");
    Serial.print("Humidity: ");
    Serial.print(wilgotnosc);
    Serial.println("%");

   // Wait to full timeStep period
   delay((timeStep*1000) - (millis() - timer));
} 
