#include <SD.h> //dołączenie biblioteki obsługującej kartę pamięci
#include <SPI.h> //dołączenie biblioteki obsługującej interfejs SPI

//definicja używanych pinów
#define CS 4
#define TEMP_PIN 10
#define CISN_PIN 11

//definicje używanych zmiennych

File temp_file;
File cisn_file;

String temp_string;
String cisn_string;

int temp_sensor;
int cisn_sensor;

void setup() {

  pinMode(TEMP_PIN, INPUT); //przypisanie pinom funkcji wejścia
  pinMode(CISN_PIN, INPUT);
  
  Serial.begin(9600); //inicjalizacja portu szeregowego
  while (!Serial) //funkcja oczekująca na inicjalizację portu szeregowego
  {
    ;
  }

  Serial.print("Inicjalizacja karty SD..."); //drukujemy status na port szeregowy
  if (!SD.begin(CS)) { //inicjalizacja karty pamięci i sprawdzenie stanu  inicjalizacji
    Serial.println("niepowodzenie!");
    return;
  }
  Serial.println("OK.");

}

void loop() {

  temp_string = "";
  temp_sensor = analogRead(TEMP_PIN); //odczyt wartości z pinu i wpisanie do zmiennej
  temp_string = String(millis()/1000) + "," + String(temp_sensor); //stworzenie stringa tekstowego ze znacznikiem czasu i danymi

  temp_file = SD.open("temp.txt",FILE_WRITE);  //utworzenie pliku temp.txt i obiektu temp_file

  if (temp_file)
  {
    temp_file.println(temp_string); //drukowanie ciągu znaków do pliku poprzez użycie obiektu temp_file
    temp_file.close();  //zamknięcie pliku
    Serial.println(temp_string);
  }
  else
  {
    Serial.println("Błąd przy otwieraniu pliku...");
  }

  delay(1000);
  
}
