/*
    BMP085 / BMP180 Processing
    Version 1.0.1
    Read more: http://www.jarzebski.pl/arduino/czujniki-i-sensory/czujniki-cisnienia-bmp085-bmp180.html
    
    Web: http://www.jarzebski.pl
    (c) 2014 by Korneliusz Jarzebski
*/

import processing.serial.*;
 
Serial myPort;

boolean hasData = false;

int actualSample = 0;
int maxSamples = 300;
int sampleStep = 2;

float[] tempValues = new float[maxSamples+1];
int minTemp = 0;
int maxTemp = 0;

float[] pressureValues = new float[maxSamples+1];
int minPressure = 0;
int maxPressure = 0;

float[] altitudeValues = new float[maxSamples+1];
int minAltitude = 0;
int maxAltitude = 0;

void setup ()
{
  size(670, 750);        
  myPort = new Serial(this, Serial.list()[0], 9600);
  myPort.bufferUntil(10);
  background(0);
}

void drawChart(String title, float[] data, int minValue, int maxValue, int x, int y, int h, int ls, int fs)
{  
  strokeWeight(1);
  noFill();
  stroke(50,50,50);
  rect(x, y, (maxSamples*sampleStep)+50, h+50);

  strokeWeight(1);
  stroke(90,90,90);
 
  for (float t = minValue; t <= maxValue; t = t + ls)
  {
     float line = map(t, minValue, maxValue, 0, h);
     line(x+40, y+h-line+16, x+(maxSamples*sampleStep)+40, y+h-line+16);
     fill(200, 200, 200);
     textSize(fs);
     text(int(t), 5+x, h-line+20+y);
  }
  
  textSize(14);
  String title2 = title + " " + nf(data[actualSample-1], 0, 2);  
  text(title2, ((maxSamples*sampleStep)/2)-(textWidth(title2)/2)+40, h+40+y);

  strokeWeight(2);
  
  for (int i = 1; i < actualSample; i++)
  {
    stroke(204, 102, 0);
    float v0 = map(data[i-1], minValue, maxValue, 0, h);
    float v1 = map(data[i], minValue, maxValue, 0, h);
    line(((i-1)*sampleStep)+40+x, h-v0+16+y, (i*sampleStep)+40+x, h-v1+16+y);
  }
}

void draw () 
{
  if (!hasData) return;
  
  background(0);
  
  drawChart("Temperatura", tempValues, minTemp, maxTemp, 10, 10, 100, 1, 14);
  drawChart("Cisnienie", pressureValues, minPressure, maxPressure, 10, 200, 200, 50, 10);
  drawChart("Wysokosc", altitudeValues, minAltitude, maxAltitude, 10, 490, 200, 1, 12);
}
 
void nextSample()
{
  if (actualSample == maxSamples)
  {
    float lastTemp = tempValues[maxSamples];
    float lastPressure = pressureValues[maxSamples];
    float lastAltitude = altitudeValues[maxSamples];
     
    for (int i = 1; i <= (maxSamples-1); i++)
    {
      tempValues[i-1] = tempValues[i];
      pressureValues[i-1] = pressureValues[i];
      altitudeValues[i-1] = altitudeValues[i];       
    }
     
    tempValues[(maxSamples-1)] = lastTemp;
    pressureValues[(maxSamples-1)] = lastPressure;
    altitudeValues[(maxSamples-1)] = lastAltitude;
  } else 
  {
    actualSample++;
  }  
}

void serialEvent (Serial myPort) 
{
  String inString = myPort.readStringUntil(10);
 
  if (inString != null)
  {
    inString = trim(inString);
    String[] list = split(inString, ':');
   
    String testString = trim(list[0]);
 
    if (list.length != 3) return;
   
    float temp = float(list[0]);
    float pressure = float(list[1]);
    float altitude = float(list[2]);

    if (actualSample == 0)
    {
      for (int i = 0; i <= maxSamples; i++)
      {
        tempValues[i] = temp;
        pressureValues[i] = pressure;
        altitudeValues[i] = altitude;
      }
    }

    tempValues[actualSample] = temp;
    pressureValues[actualSample] = pressure;
    altitudeValues[actualSample] = altitude;
  
    maxTemp = floor(max(tempValues))+1;
    minTemp = ceil(min(tempValues))-1;

    maxPressure = floor(max(pressureValues))+200;
    minPressure = ceil(min(pressureValues))-200;
   
    maxAltitude = floor(max(altitudeValues))+2;
    minAltitude = ceil(min(altitudeValues))-2;
    
    if (actualSample > 1)
    {
      hasData = true;
    }

    nextSample();
  }
}
