/*
    BMP085 / BMP180 Example for Processing
    Version 1.0.1
    Read more: http://www.jarzebski.pl/arduino/czujniki-i-sensory/czujniki-cisnienia-bmp085-bmp180.html
    
    Web: http://www.jarzebski.pl
    (c) 2014 by Korneliusz Jarzebski
*/

#include <Wire.h>
#include <Adafruit_BMP085.h>

Adafruit_BMP085 bmp;

float sealevelPressure;
  
void setup() 
{
  Serial.begin(9600);
  
  if (!bmp.begin())
  {
    Serial.println("Nie odnaleziono czujnika BMP085 / BMP180");
    while (1) {}
  }
}
  
void loop() 
{
    // Odczytujemy temperature i cisnienie
    float temp = bmp.readTemperature();
    float pressure = bmp.readPressure();
    
    // Sami wyliczamy wysokosc
    sealevelPressure = 101325;
    float altitude = 44330 * (1.0 - pow(pressure / sealevelPressure, 0.1903));
    
    // Wyczucamy dane na port szeregowy
    Serial.print(temp);
    Serial.print(":");
    Serial.print(pressure);
    Serial.print(":");
    Serial.print(altitude);
    Serial.println();
}
